/*
 * Decompiled with CFR 0.152.
 */
package stormedpanda.simplyjetpacks.datagen;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.IRequirementsStrategy;
import net.minecraft.advancements.criterion.RecipeUnlockedTrigger;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.ShapelessRecipeBuilder;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CustomShapelessRecipeBuilder
extends ShapelessRecipeBuilder {
    private final Item result;
    private final int count;
    private final List<Ingredient> ingredients = Lists.newArrayList();
    private final Advancement.Builder advancement = Advancement.Builder.func_200278_a();
    private String group;
    private final List<ICondition> conditions = new ArrayList<ICondition>();

    public CustomShapelessRecipeBuilder(IItemProvider result, int count) {
        super(result, count);
        this.result = result.func_199767_j();
        this.count = count;
    }

    public CustomShapelessRecipeBuilder addCondition(ICondition condition) {
        this.conditions.add(condition);
        return this;
    }

    private boolean hasCriteria() {
        return !this.advancement.func_200277_c().isEmpty();
    }

    public static CustomShapelessRecipeBuilder shapeless(IItemProvider item) {
        return new CustomShapelessRecipeBuilder(item, 1);
    }

    public static CustomShapelessRecipeBuilder shapeless(IItemProvider item, int count) {
        return new CustomShapelessRecipeBuilder(item, count);
    }

    public CustomShapelessRecipeBuilder requires(ITag<Item> item) {
        return this.requires(Ingredient.func_199805_a(item));
    }

    public CustomShapelessRecipeBuilder requires(IItemProvider item) {
        return this.requires(item, 1);
    }

    public CustomShapelessRecipeBuilder requires(IItemProvider item, int count) {
        for (int i = 0; i < count; ++i) {
            this.requires(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item}));
        }
        return this;
    }

    public CustomShapelessRecipeBuilder requires(Ingredient item) {
        return this.requires(item, 1);
    }

    public CustomShapelessRecipeBuilder requires(Ingredient item, int count) {
        for (int i = 0; i < count; ++i) {
            this.ingredients.add(item);
        }
        return this;
    }

    public CustomShapelessRecipeBuilder unlockedBy(String name, ICriterionInstance criteria) {
        this.advancement.func_200275_a(name, criteria);
        return this;
    }

    public CustomShapelessRecipeBuilder group(String group) {
        this.group = group;
        return this;
    }

    public void func_200482_a(Consumer<IFinishedRecipe> consumer) {
        this.func_200485_a(consumer, Registry.field_212630_s.func_177774_c((Object)this.result));
    }

    public void func_200484_a(Consumer<IFinishedRecipe> consumer, String id) {
        ResourceLocation resourceLocation = Registry.field_212630_s.func_177774_c((Object)this.result);
        if (new ResourceLocation(id).equals((Object)resourceLocation)) {
            throw new IllegalStateException("Shapeless Recipe " + id + " should remove its 'save' argument");
        }
        this.func_200485_a(consumer, new ResourceLocation(id));
    }

    public void func_200485_a(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
        this.ensureValid(id);
        if (this.hasCriteria()) {
            this.advancement.func_200272_a(new ResourceLocation("simplyjetpacks", "root")).func_200275_a("has_the_recipe", (ICriterionInstance)RecipeUnlockedTrigger.func_235675_a_((ResourceLocation)id)).func_200271_a(AdvancementRewards.Builder.func_200280_c((ResourceLocation)id)).func_200270_a(IRequirementsStrategy.field_223215_b_);
        }
        consumer.accept(new Result(id, this.result, this.count, this.group == null ? "" : this.group, this.ingredients, this.advancement));
    }

    private void ensureValid(ResourceLocation id) {
    }

    public class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final Item result;
        private final int count;
        private final String group;
        private final List<Ingredient> ingredients;
        private final Advancement.Builder advancement;

        public Result(ResourceLocation id, Item result, @Nullable int count, String group, List<Ingredient> ingredients, Advancement.Builder advancement) {
            this.id = id;
            this.result = result;
            this.count = count;
            this.group = group;
            this.ingredients = ingredients;
            this.advancement = advancement;
        }

        public void func_218610_a(JsonObject jsonObject) {
            JsonArray ingredientsArray = new JsonArray();
            for (Ingredient ingredient : this.ingredients) {
                ingredientsArray.add(ingredient.func_200304_c());
            }
            jsonObject.add("ingredients", (JsonElement)ingredientsArray);
            JsonObject resultObject = new JsonObject();
            resultObject.addProperty("item", Registry.field_212630_s.func_177774_c((Object)this.result).toString());
            if (this.count > 1) {
                resultObject.addProperty("count", (Number)this.count);
            }
            jsonObject.add("result", (JsonElement)resultObject);
        }

        public JsonObject func_200441_a() {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("type", Registry.field_218368_I.func_177774_c(this.func_218609_c()).toString());
            JsonArray conditionsArray = new JsonArray();
            if (!CustomShapelessRecipeBuilder.this.conditions.isEmpty()) {
                for (ICondition condition : CustomShapelessRecipeBuilder.this.conditions) {
                    conditionsArray.add((JsonElement)CraftingHelper.serialize((ICondition)condition));
                }
                jsonObject.add("conditions", (JsonElement)conditionsArray);
            }
            this.func_218610_a(jsonObject);
            return jsonObject;
        }

        @Nonnull
        public IRecipeSerializer<?> func_218609_c() {
            return IRecipeSerializer.field_222158_b;
        }

        @Nonnull
        public ResourceLocation func_200442_b() {
            return this.id;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return CustomShapelessRecipeBuilder.this.hasCriteria() ? this.advancement.func_200273_b() : null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return new ResourceLocation("simplyjetpacks", (this.group != null ? this.group : "") + this.id.func_110623_a());
        }
    }
}

